// register.c

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "main.h"
#include "stringtools.h"
#include "register.h"
#include "gworld.h"
#include "midi.h"
#include "dialog.h"
#include "graphics.h"

Boolean firstOpen = true;
long undimTime = 0;
int registerDialogID = -1;

enum
{
	iRegisterNow = 1,
	iEnterSerialNumber,
	iLater
};

enum
{
	iRegisterOnline = 1,
	iRegisterMail,
	iGoBack
};

enum
{
	iOK = 1,
	iNoSerial,
	iUserName,
	iSerialNumber
};


static pascal Boolean RegisterFilter( DialogPtr theDialog, EventRecord *theEvent, short *itemHit )
{
	// Undim buttons on main dialog after a suitable delay
	if( TickCount() >= undimTime )
	{
		SetDialogHilite( theDialog, iRegisterNow, 0 );
		SetDialogHilite( theDialog, iEnterSerialNumber, 0 );
		SetDialogHilite( theDialog, iLater, 0 );
		undimTime = 0x7FFFFFFF;
		firstOpen = false;
	}

	// Catch return/enter and absorb bad keys
	if( theEvent->what == keyDown || theEvent->what == autoKey )
	{
		short itemType;
		Rect itemRect;
		Handle hItem;
		
		GetDialogItem( theDialog, 1, &itemType, &hItem, &itemRect);
		
		if( GetControlHilite((ControlHandle)hItem) == 0 )
		{		
			char key = theEvent->message & charCodeMask;
	
			switch( key )
			{
				case '\r':
				case 0x3:
					*itemHit = 1;
					FlashItem( theDialog, 1 );
					return true;
			}
		}
	}

	return false;
}

void Register( Boolean isFullScreen )
{
	ModalFilterUPP registerUPP = NewModalFilterUPP( RegisterFilter );
	ProcessSerialNumber myProcess = { 0, kCurrentProcess };
	DialogPtr myDialog;
	Str255 regCode, regName;
	Boolean done = false;
	short item;
	
	if( IsRegistered( ) )
	{
		Inform( infThanksForRegistering );
	}
	else
	{
		if( context )
		{
			DSpContext_SetState( context, kDSpContextState_Paused );
		}
				
		do
		{
			FlushEvents( everyEvent, 0L );
			myDialog = GetNewDialog( registerDialogID = dShareware, nil, kFirstWindowOfClass );
			SetPortDialogPort( myDialog );
			ShowWindow( GetDialogWindow(myDialog) );
			SetDialogDefaultItem( myDialog, iRegisterNow );
			ArrowCursor( );

			if( firstOpen )
			{
				SetDialogHilite( myDialog, iRegisterNow, 255 );
				SetDialogHilite( myDialog, iEnterSerialNumber, 255 );
				SetDialogHilite( myDialog, iLater, 255 );
				undimTime = TickCount() + (60*8);
			}
			else
			{
				undimTime = 0x7FFFFFFF;
			}
			
			do
			{
				ModalDialog( registerUPP, &item );
			}
			while( item != iRegisterNow       &&
			       item != iEnterSerialNumber &&
			       item != iLater                );

			DisposeDialog( myDialog );
			
			switch( item )
			{
				case iLater:
					done = true;
					break;
				
				case iRegisterNow:
					if( noErr == LaunchURL( "\phttp://www.candycrisis.com/register.html" ) )
					{
						GoToBackground( isFullScreen, false );
					}
					else
					{
						Inform( infCouldntOpenBrowser );
					}
					break;
				
				case iEnterSerialNumber:
					myDialog = GetNewDialog( registerDialogID = dSerialNumber, nil, kFirstWindowOfClass );
					SetPortDialogPort( myDialog );
					ShowWindow( GetDialogWindow(myDialog) );
					SetDialogDefaultItem( myDialog, iOK );

					do
					{
						ModalDialog( registerUPP, &item );
					}
					while( item != iNoSerial  &&
					       item != iOK           );
					
					GetDialogText( myDialog, iSerialNumber, regCode );
					GetDialogText( myDialog, iUserName, regName );
					DisposeDialog( myDialog );

					TrimPString( regCode );
					TrimPString( regName );

					if( regCode[0] == 35 &&
					    toupper(regCode[1]) == 'S' &&
					    toupper(regCode[2]) == 'K' &&
					    toupper(regCode[3]) == 'I' &&
					    toupper(regCode[4]) == 'T' &&
					           (regCode[5]) == '2' &&
					           (regCode[6]) == '-'    )
					{
						Inform( infOldCode );
					}
					else
					{
						if( regCode[0] > 17 ) regCode[0] = 17;
						
						if( regName[0] > 63 ) regName[0] = 63;

						if( item == iOK )
						{
							CopyPascalStringToC( regName, registeredName );
							CopyPascalStringToC( regCode, registeredKey );
							
							if( IsRegistered() )
							{
								Inform( infThanksForRegistering );
								done = true;
							}
							else
							{
								Inform( infIncorrectCode );
							}
						}
					}
					break;
			}
		}
		while( !done );	
		
		if( context )
		{
			DSpContext_SetState( context, kDSpContextState_Active );
			DSpContext_GetFrontBuffer( context, &backdropPort );
		}
		
		InvisiCursor( );
		DisposeModalFilterUPP( registerUPP );
	}
}

void GetDialogText( DialogPtr theDialog, short which, Str255 what )
{
	short itemType;
	Handle itemHandle;
	Rect itemRect;
	
	GetDialogItem( theDialog, which, &itemType, &itemHandle, &itemRect );
	
	HLock( itemHandle );
	GetDialogItemText( itemHandle, what );
	HUnlock( itemHandle );
}

void SetDialogText( DialogPtr theDialog, short which, Str255 what )
{
	short itemType;
	Handle itemHandle;
	Rect itemRect;
	
	GetDialogItem( theDialog, which, &itemType, &itemHandle, &itemRect );
	
	HLock( itemHandle );
	SetDialogItemText( itemHandle, what );
	HUnlock( itemHandle );
}


void GetDialogRect( DialogPtr myDialog, short which, Rect *itemRect )
{
	Handle itemHandle;
	short itemType;
	
	GetDialogItem( myDialog, which, &itemType, &itemHandle, itemRect );
}
